﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Newtonsoft.Json;
using Ext.Net;
using System.IO;
using System.Data;
using DataAccess;
using System.Collections;
using System.Web.Script.Serialization;

//setup an alias for all direct method calls on this control
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "UCASPATHWAY")]

public partial class ucAssignPathway : System.Web.UI.UserControl
{
    public BaseMaster BaseMstr { get; set; }

    /// <summary>
    /// US:6438 US:6677 show the assign pathway popup
    /// </summary>
    public void Show()
    {
        wndApplyPathway.Show();
    }

    public void LoadControl(int nPWType)
    {


    }

    /// <summary>
    /// US:7304 US:6438 US:6677  initialize the assign pathway dialog
    /// </summary>
    /// <returns></returns>
    public bool InitializeControl()
    {
        tfPWAPWTitle.Text = "";

        //default baseline to today
        dfPWABaseline.SelectedDate = DateTime.Today;

        //clear the tree
        Ext.Net.Node ndRoot;
        ndRoot = new Node() { Text = "" };
        ndRoot.Expanded = true;
        ndRoot.EmptyChildren = true;
        treeASPWEvents.Root.Add(ndRoot);

        //get the pathway type
        long lPWType = 2;//2 = outpatient
        if (rdoPWOutpatient.Checked)
        {
            lPWType = 1;
        }

        //Get all clinical program areas for this site
        CCPA cpa = new CCPA();
        DataSet dsCPA = cpa.GetCPADS(BaseMstr,
                                    BaseMstr.RegionID,
                                    BaseMstr.SiteID);


        //loop and get all pathways for each CPA
        foreach (DataTable tableCPA in dsCPA.Tables)
        {
            //clinical program area
            foreach (DataRow rowCPA in tableCPA.Rows)
            {
                long lCPAID = CDataUtils2.GetDSLongValue(rowCPA, "CPA_ID");

                ////////////////////////////////////////////////
                //pathways
                ////////////////////////////////////////////////
                DataSet dsPW = cpa.GetCPAPWDS(BaseMstr, lCPAID);
                foreach (DataTable tablePW in dsPW.Tables)
                {
                    foreach (DataRow rowPW in tablePW.Rows)
                    {
                        long lPWTypeID = CDataUtils2.GetDSLongValue(rowPW, "PW_TYPE_ID");
                        long lPWID = CDataUtils2.GetDSLongValue(rowPW, "PW_ID");
                        if (lPWTypeID != 3) //dont show open pathways
                        {
                            //dont show pathways that dont match our selected radio type
                            if (lPWTypeID == lPWType)
                            {
                                Ext.Net.Node ndPW = new Ext.Net.Node()
                                {
                                    Text = CDataUtils2.GetDSStringValue(rowPW, "PW_TITLE"),
                                    Icon = Icon.FolderPage,
                                    NodeID = CDataUtils2.GetDSStringValue(rowPW, "PW_ID")
                                    //,
                                    //Checked = false,
                                };
                                ndPW.Expanded = false;
                                ndPW.EmptyChildren = true;
                                ndRoot.Children.Add(ndPW);

                                ////////////////////////////////////////////////////
                                //events
                                ///////////////////////////////////////////////////
                                DataSet dsEvent = cpa.GetPWEventDS(BaseMstr,
                                                                    lPWID);

                                foreach (DataTable tableEvent in dsEvent.Tables)
                                {
                                    foreach (DataRow rowEvent in tableEvent.Rows)
                                    {
                                        Ext.Net.Node ndEvent = new Ext.Net.Node()
                                        {
                                            Text = CDataUtils2.GetDSStringValue(rowEvent, "EVENT_TITLE"),
                                            Icon = Icon.FolderPage,
                                            NodeID = CDataUtils2.GetDSStringValue(rowEvent, "PW_ID") + "|" + CDataUtils2.GetDSStringValue(rowEvent, "PW_EVENT_ID"),
                                        };
                                        ndEvent.Expanded = false;
                                        ndEvent.EmptyChildren = true;
                                        ndPW.Children.Add(ndEvent);

                                        //////////////////////////////////////////////////////////
                                        //modules
                                        //////////////////////////////////////////////////////////
                                        DataSet dsEventModules = cpa.GetPWEventModuleDS(BaseMstr,
                                                                                        CDataUtils2.GetDSLongValue(rowEvent, "PW_ID"),
                                                                                        CDataUtils2.GetDSLongValue(rowEvent, "PW_EVENT_ID"));


                                        foreach (DataTable tableMod in dsEventModules.Tables)
                                        {
                                            foreach (DataRow rowMod in tableMod.Rows)
                                            {
                                                Ext.Net.Node ndModule = new Ext.Net.Node()
                                                {
                                                    Text = CDataUtils2.GetDSStringValue(rowMod, "MODULE"),
                                                    Icon = Icon.Page,
                                                    NodeID = CDataUtils2.GetDSStringValue(rowMod, "PW_EVENT_ID") + "|" +
                                                             CDataUtils2.GetDSStringValue(rowMod, "MID") + "|" + 
                                                             CDataUtils2.GetDSStringValue(rowMod, "SORT_ORDER"),

                                                };
                                                ndModule.Expanded = false;
                                                ndModule.EmptyChildren = true;
                                                ndEvent.Children.Add(ndModule);
                                                ndEvent.Expanded = true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                     }
                  }
               }
           }
        

        //update the view
        treeASPWEvents.Update();
            
        return true;
    }

    /// <summary>
    /// US:6438 US:6677 page load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {

    }
    
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// US:7304 US:6438 US:6677 user clicked inpatient/outpatient filter
    /// </summary>
    public void OnPWFilter(string strPWType)
    {
        InitializeControl();
    }
    
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", SuccessFn = "fnASCPAReloadTree")]
    /// <summary>
    /// US:6438 US:6677 user clicked ok
    /// </summary>
    public long OnOK(string strPWIDS)
    {
        
        //get the pathway type
        long lPWType = 2;//2 = outpatient
        if (rdoPWOutpatient.Checked)
        {
            lPWType = 1;
        }

        string strPWCheck = strPWIDS.Replace(",", "");
        strPWCheck = strPWCheck.Replace(" ", "");
        if (strPWCheck.Length < 1)
        {
            BaseMstr.ShowSystemFeedback("Please select a pathway to apply to this patient!", "Data Entry Error");
            return -1;
        }

        //make sure we have a valid pathway title
        if (tfPWAPWTitle.Text.Length < 1)
        {
            BaseMstr.ShowSystemFeedback("Please enter a valid title for this pathway!", "Data Entry Error");
            return -1;
        }


        //check to see that patient does not already have a pathway with this name:
        CCPA cpa = new CCPA();
        string strNameCheck = tfPWAPWTitle.Text.ToUpper().Trim();
        DataSet dsPatPW = cpa.GetPatPWDS(this.BaseMstr, this.BaseMstr.SelectedPatientID);
        foreach (DataTable dt in dsPatPW.Tables)
        {
            foreach (DataRow dr in dt.Rows)
            {
                string strPW = CDataUtils2.GetDSStringValue(dr, "PW_TITLE");
                strPW = strPW.Trim().ToUpper();
                if (strPW == strNameCheck)
                {
                    BaseMstr.ShowSystemFeedback("Patient already has a pathway by this title. Please enter a unique title for this pathway", "Data Entry Error");
                    return -1;
                }
            }
        }
        
        //apply the pathway
        long lPatPWID = cpa.ApplyPathway( BaseMstr, 
                                          BaseMstr.SelectedPatientID, 
                                          tfPWAPWTitle.Text, 
                                          dfPWABaseline.SelectedDate,
                                          strPWIDS );


        //close the window
        wndApplyPathway.Close();

        //return the new pathway we just created
        return lPatPWID;        
   }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// US:6438 US:6677 user clicked cancel
    /// </summary>
    public void OnCancel()
    {
        //clear the tree
        Ext.Net.Node ndRoot;
        ndRoot = new Node() { Text = "" };
        ndRoot.Expanded = true;
        ndRoot.EmptyChildren = true;
        treeASPWEvents.Root.Add(ndRoot);

        //close this window
        wndApplyPathway.Close();
    }
}